/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.PlayerComponent;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.network.packet.SwingArmPacket;

public class OffhandCooldownTracker
implements PlayerComponent<OffhandCooldownTracker>,
EntityComponentInitializer {
    public static final class_2960 KEY = Mantle.getResource("offhand_cooldown");
    public static final Function<OffhandCooldownTracker, Float> COOLDOWN_TRACKER = OffhandCooldownTracker::getCooldown;
    private static final Function<OffhandCooldownTracker, Boolean> ATTACK_READY = OffhandCooldownTracker::isAttackReady;
    public static final ComponentKey<OffhandCooldownTracker> CAPABILITY = ComponentRegistry.getOrCreate((class_2960)KEY, OffhandCooldownTracker.class);
    private final LazyOptional<OffhandCooldownTracker> capabilityInstance = LazyOptional.of(() -> this);
    @Nullable
    private final class_1657 player;
    private int lastCooldown = 0;
    private int attackReady = 0;
    private int enabled = 0;

    public OffhandCooldownTracker() {
        this.player = null;
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(CAPABILITY, OffhandCooldownTracker::attachCapability);
    }

    public static void register() {
    }

    private static OffhandCooldownTracker attachCapability(class_1657 player) {
        return new OffhandCooldownTracker(player);
    }

    private int getTicksExisted() {
        if (this.player == null) {
            return 0;
        }
        return this.player.field_6012;
    }

    public boolean isEnabled() {
        return this.enabled > 0;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable ? ++this.enabled : --this.enabled;
    }

    public void applyCooldown(int cooldown) {
        this.lastCooldown = cooldown;
        this.attackReady = this.getTicksExisted() + cooldown;
    }

    public float getCooldown() {
        int ticksExisted = this.getTicksExisted();
        if (ticksExisted > this.attackReady || this.lastCooldown == 0) {
            return 1.0f;
        }
        return class_3532.method_15363((float)((float)(this.lastCooldown + ticksExisted - this.attackReady) / (float)this.lastCooldown), (float)0.0f, (float)1.0f);
    }

    public boolean isAttackReady() {
        return this.getTicksExisted() + this.lastCooldown > this.attackReady;
    }

    public static float getCooldown(class_1657 player) {
        return CAPABILITY.maybeGet((Object)player).map(COOLDOWN_TRACKER).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public static void applyCooldown(class_1657 player, int cooldown) {
        CAPABILITY.maybeGet((Object)player).ifPresent(cap -> cap.applyCooldown(cooldown));
    }

    public static boolean isAttackReady(class_1657 player) {
        return CAPABILITY.maybeGet((Object)player).map(ATTACK_READY).orElse(true);
    }

    public static void applyCooldown(class_1657 player, float attackSpeed, int cooldownTime) {
        OffhandCooldownTracker.applyCooldown(player, Math.round((float)cooldownTime / attackSpeed));
    }

    public static void swingHand(class_1309 entity, class_1268 hand, boolean updateSelf) {
        if (!entity.field_6252 || entity.field_6279 >= entity.method_6028() / 2 || entity.field_6279 < 0) {
            entity.field_6279 = -1;
            entity.field_6252 = true;
            entity.field_6266 = hand;
            if (!entity.method_37908().field_9236) {
                SwingArmPacket packet = new SwingArmPacket((class_1297)entity, hand);
                if (updateSelf) {
                    MantleNetwork.INSTANCE.sendToTrackingAndSelf(packet, (class_1297)entity);
                } else {
                    MantleNetwork.INSTANCE.sendToTracking(packet, (class_1297)entity);
                }
            }
        }
    }

    public void readFromNbt(class_2487 tag) {
        tag.method_10569("attackReady", this.attackReady);
        tag.method_10569("lastCooldown", this.lastCooldown);
        tag.method_10569("enabled", this.enabled);
    }

    public void writeToNbt(class_2487 tag) {
        this.attackReady = tag.method_10550("attackReady");
        this.lastCooldown = tag.method_10550("lastCooldown");
        this.enabled = tag.method_10550("enabled");
    }

    public OffhandCooldownTracker(@Nullable class_1657 player) {
        this.player = player;
    }
}

